// **** Subida de imagenes de el incidente ****

// Representa el numero de imagenes maximas que puede subir el usuario en un incidente
const MAX_IMAGES = 10
// Representa el tamaño maximo(En MegaBytes) que puede tener una imagen de incidente
const MAX_IMAGE_SIZE = 10

// Arreglo que guardara las imagenes seleccionadas de manera global
var filesSelected = []

// Contenedor <div> de las primeras posibles 5 imagenes
var firstImagesContainer = $("#first-images")
// Contenedor <div> de las ultimas posibles 5 imagenes
var lastImagesContainer = $("#last-images")

// Contenedor de los archivos subidos
var contratosContainer = document.getElementById("contracts-container")

// Funcion que verificara si el usuario cumple el numero permitido de imagenes(Cuando se clickee el input file)
function verifyLimitImages(event) {

    if (filesSelected.length == 10) {
        event.preventDefault()
        showWarningAlert("¡Aviso!", `Solo se permiten subir maximo ${MAX_IMAGES} fotografias.`)
    }

}


// Funcion eliminara una imagen seleccionada del incidente de la lista
function onRemoveImgBtnClick(file) {
    // Elimina la imagen seleccionada de la lista
    filesSelected = filesSelected.filter(e => e !== file)

    // Cada vez que remueva una imagen, decrementara el contador de imagenes seleccionadas
    $("#img-counter").text(`${filesSelected.length}/10`)

    // Verificara el numero de imagenes que estan en la lista actualmente.
    // Si hay cero, mostrara la leyenda de 'No hay fotografias'
    if (filesSelected.length == 0) {
        $("#no-photos-incidente").fadeIn(300)
    }
}


// Funcion que mostrara la imagen subida en la UI
function showImageSelected(file) {
    // Cada vez que seleccione una imagen, aumentara el contador de imagenes seleccionadas
    $("#img-counter").text(`${filesSelected.length}/10`)

    // Ocultara la leyenda que dice 'No hay fotografias', ya que selecciono una fotografia
    $("#no-photos-incidente").hide()

    // Crea el contenedor para el <img>
    let containerImg = jQuery('<div>', {
        class: "incidente-container-img"
    })

    // Crea el boton de "remover imagen" para la imagen de el incidente
    let removeBtn = jQuery('<i>', {
        class: "remove-img-btn-incidente"
    })
    removeBtn.addClass("material-icons md-18")
    removeBtn.text("close")

    // Crea el elemento <a> para mostrar el <img> en forma modal(En un popup)
    let modalImgContainer = jQuery('<a>', {
        class: "pop"
    })
    modalImgContainer.attr('href', "#")

    // Crea el elemento <img>
    var img = jQuery('<img>', {
        class: 'incidente-img'
    })
    img.addClass("img-thumbnail")
    //img.addClass("")
    // Leera la imagen seleccionada con este objeto
    var reader = new FileReader();
    reader.onload = function (e) {
        img.attr('src', e.target.result);
    }
    reader.readAsDataURL(file);

    // Agrega el <img> como elemento hijo del contenedor <a>(Se usara para mostrar el popup con la imagen)
    modalImgContainer.append(img)
    // Agrega el contenedor modal <a> como hijo del contenedor <div>
    containerImg.append(modalImgContainer)


    // Agrega el boton de remover como elemento hijo del contenedor <div>
    containerImg.append(removeBtn)

    // Cuando el usuario clickee el boton de remover imagen, removera la imagen correspondiente
    removeBtn.click(function () {
        //containerImg.remove() // Ocultara la imagen correspondiente
        containerImg.fadeOut(300, function () { $(this).remove(); })
        onRemoveImgBtnClick(file) // Eliminara la imagen seleccionada de la lista
    })

    containerImg.appendTo("#incidentes-img")

}

window.onload = function () { // Cuando la ventana se cargue, ejecutara este bloque de codigo
    // Checa el soporte de la API File
    if (window.File && window.FileList && window.FileReader) {
        // Guarda el input de donde el usuario subira las fotos del incidente
        let inputFile = $("#incidente-img") // Input type File
        inputFile.change(function (event) {
            console.log("cambio el input file")
            // Objeto de FileList
            var files = event.target.files
            for (var i = 0; i < files.length; i++) {
                var file = files[i]
                // Si la imagen seleccionada, ya la habia seleccionado antes, no hara nada
                if (!filesSelected.filter(e => e.name === file.name).length > 0) {

                    // Verifica que el archivo sea PNG,JPEG,WEBP,JPG
                    if (isImage(file)) {
                        // Verificara que el archivo no sobrepase los 10 MB
                        if (isFileSizeValid(file, MAX_IMAGE_SIZE)) {

                            // Verificara el total de imagenes que ha subido el usuario
                            // si se va a pasar de el limite, no mostrara la imagen
                            if (filesSelected.length < MAX_IMAGES) {

                                // Agrega el archivo seleccionado a el array temporal
                                filesSelected.push(file)
                                // Muestra en la UI la imagen seleccionada
                                showImageSelected(file)
                            } else {
                                showWarningAlert("¡Aviso!", `Solo se permiten subir maximo ${MAX_IMAGES} fotografias.`)
                            }
                        } else {
                            showWarningAlert("¡Aviso!", `La imagen debe pesar menos de ${MAX_IMAGE_SIZE} MegaBytes(MB)`)
                        }
                    } else {
                        // Si no es PDF mostrara una alerta de error
                        showFailAlert("¡Atención!", "Solo se permiten archivos PNG,JPEG o WEBP")
                    }
                } else {
                    console.log("hey ya lo selecciono")
                }
            }
            // Al final limpiara el input de tipo File
            inputFile.val(null)
        })
    } else {
        console.log("API NO DISPONIBLE")
    }
}


// ***** Funciones generales *******
function registrarIncidente() {
    showLoadingAlert("Registrando incidente...")
    var csrftoken = $("[name=csrfmiddlewaretoken]").val();
    // Crea un objeto FormData para enviarlo a traves de la peticion HTTP
    let formData = new FormData()
    // Adjunta las posibles imagenes de el incidente
    for (var i = 0; i < filesSelected.length; i++) {
        formData.append("incidentes-img[]", filesSelected[i])
    }
    // ADJUNTA LOS DATOS A REGISTRAR
    formData.append("fecha-incidente", $("[name=fecha-incidente]").val())
    formData.append("responsable-incidente", $("[name=responsable-incidente]").val())
    formData.append("costo-incidente", $("[name=costo-incidente]").val())
    formData.append("observaciones-incidente", $("[name=observaciones-incidente]").val())
    formData.append("aseguradora-incidente", $("[name=aseguradora-incidente]").val())
    formData.append("taller-incidente", $("[name=taller-incidente]").val())
    formData.append("fecha-reparacion", $("[name=fecha-reparacion]").val())
    formData.append("factura-incidente", $("[name=factura-incidente]").prop('files')[0])
    formData.append("fecha-entrega", $("[name=fecha-entrega]").val())
    formData.append("fecha-ingreso-taller", $("[name=fecha-ingreso-taller]").val())

    $.ajax(
        {
            type: "POST",
            url: `${FLOTILLAS_PREFIX}/registrar-incidente/${$("[name=vehiculo-id]").val()}`,
            processData: false,
            contentType: false,
            cache: false,
            data: formData,
            headers: {
                "X-CSRFToken": csrftoken
            },
            success: function (data) {
                if (data == "success") {
                    Swal.close()
                    Swal.fire(
                        {
                            title: "¡Exito!",
                            text: "Se registro el incidente exitosamente.",
                            icon: 'success',
                            allowOutsideClick: false
                        }
                    ).then((result) => {
                        if (result.isConfirmed) {
                            window.top.close()
                        }
                    })
                }
            },
            error: function (a, b, c) {
                Swal.close()
                alert(a + " " + b + "" + c)
                console.log("errrrrorr")
            }
        }
    )
}

// Funcion que se llamara cuando se quiera subir el formulario
function onFormSubmit(event) {
    event.preventDefault()
    // Si el usuario NO subio la factura del incidente, mostrara una alerta de aviso
    // y cancelara la subida de el formulario

    if ($('[name="factura-incidente"]').get(0).files.length === 0) {
        showWarningAlert(title = "Aviso", message = "Debe subir el archivo de la factura de el incidente")
    } else {
        // Registrara el incidente
        registrarIncidente()


        /*
        // Al querere subir el formulario creara dinamicamente input de tipo 'file' para agregarle
        // las imagenes seleccionadas del incidente y subirlas al servidor
        for (var i = 0; i < filesSelected.length; i++) {
            //const tempInput = $('<input/>').attr('type', 'file').attr('name', `incidente-img-${i}`)
            const tempInput = document.createElement("input")
            tempInput.type = "file"
            tempInput.name = `incidente-img-${i}`

            const tempFile = filesSelected[i]
            var tst = new DataTransfer();
            //let data = new Blob()
            //let imgFile = new File()

            tst.items.add(tempFile, `incidente-${i}.jpg`);
            //tempInput.prop("files", tst.files);
            tempInput.files = tst.files
            form.appendChild(tempInput)
            //tempInput.appendTo("#incidente-form") // Agrega el input al form
        }
        //showLoadingAlert("Registrando incidente...")
        //form.submit()
        */
    }
}
