// validar-rfc.js

PROVEEDORES = `${BASE_URL}proveedores`

$(document).ready(function () {
    $("#asignar-oficinas").on('click', function () {
        showLoadingAlert('Asignando oficinas...')

        // Obtiene el id del cliente
        let idCliente = $("#id-cliente").val()

        // Objeto que almacenara los parametros en formato {clave: valor}
        let searchQuery = new URLSearchParams({
            id_cliente: idCliente
        })

        // Obtiene las oficinas seleccionadas
        let oficinaListItems = document.querySelectorAll(".checked.oficina-item")

        oficinaListItems.forEach(item => {
            // Obtiene el texto de el item
            let textContent = item.getElementsByClassName("item-text")[0].textContent
            // Agrega la oficina a los parametros
            searchQuery.append("oficinas-items[]", textContent)
        })

        var csrftoken = $("[name=csrfmiddlewaretoken]").val();

        $.ajax({
            type: "POST",
            url: `${PROVEEDORES}/asignar-oficinas`,
            headers: {
                "X-CSRFToken": csrftoken
            },
            data: searchQuery,
            processData: false,
            contentType: false,
            success: function (data) {
                showActionConfirmAlert('¡Exito!', "Se asignaron los oficinas al proveedor correctamente", () => {
                    location.reload()
                })
            },
            error: function (a, b, c) {
                console.log(a, b, c)
            }
        })
    })
})