

// Funcion que exportara el listado a excel
async function exportarExcel() {
    var query = $("#query").val()
    var fechaMulta = $("#fecha-multa").val()
    var fechaPago = $("#fecha-pago").val()
    showLoadingAlert("Generando reporte...")
    const result = await fetch(
        `${FLOTILLAS_PREFIX}/listado-multas?` + new URLSearchParams({
            query: query,
            fecha_multa: fechaMulta,
            fecha_pago: fechaPago,
            exportar_excel: "true"
        }),
    )

    const blob = await result.blob()

    objUrl = URL.createObjectURL(blob)

    const a = document.createElement('a');
    a.style.setProperty('display', 'none');
    document.body.appendChild(a);
    a.href = objUrl;
    a.download = "Reporte multas.xlsx";
    a.click();
    window.URL.revokeObjectURL(objUrl);
    a.remove();

    Swal.close()
}

// Funcion que exportara el listado a PDF
async function exportarPdf() {
    var query = $("#query").val()
    var fechaMulta = $("#fecha-multa").val()
    var fechaPago = $("#fecha-pago").val()


    showLoadingAlert("Generando reporte...")

    const result = await fetch(
        `${FLOTILLAS_PREFIX}/listado-multas?` + new URLSearchParams({
            query: query,
            fecha_multa: fechaMulta,
            fecha_pago: fechaPago,
            exportar_pdf: "true"
        }),
    )

    const blob = await result.blob()

    objUrl = URL.createObjectURL(blob)

    const a = document.createElement('a');
    a.style.setProperty('display', 'none');
    document.body.appendChild(a);
    a.href = objUrl;
    a.download = "Reporte multas.pdf";
    a.click();
    window.URL.revokeObjectURL(objUrl);
    a.remove();

    Swal.close()
}
