// validar-rfc.js

EMPRESAS = `${BASE_URL}empresas`

$(document).ready(function () {
    $("#asignar-oficinas").on('click', function () {
        showLoadingAlert('Asignando oficinas...')

        // Obtiene el id de la empresa
        let idEmpresa = $("#id-empresa").val()

        // Objeto que almacenara los parametros en formato {clave: valor}
        let searchQuery = new URLSearchParams({
            id_empresa: idEmpresa
        })

        // Obtiene las oficinas seleccionadas
        let oficinaListItems = document.querySelectorAll(".checked.oficina-item")

        oficinaListItems.forEach(item => {
            // Obtiene el texto de el item
            let textContent = item.getElementsByClassName("item-text")[0].textContent
            // Agrega la oficina a los parametros
            searchQuery.append("oficinas-items[]", textContent)
        })

        var csrftoken = $("[name=csrfmiddlewaretoken]").val();

        $.ajax({
            type: "POST",
            url: `${EMPRESAS}/asignar-oficinas`,
            headers: {
                "X-CSRFToken": csrftoken
            },
            data: searchQuery,
            processData: false,
            contentType: false,
            success: function (data) {
                showActionConfirmAlert('¡Exito!', "Se asignaron las oficinas a la empresa correctamente", () => {
                    location.reload()
                })
            },
            error: function (a, b, c) {
                console.log(a, b, c)
            }
        })
    })
})