

function getCookie(name) {
    var cookieValue = null;
    if (document.cookie && document.cookie !== '') {
        var cookies = document.cookie.split(';');
        for (var i = 0; i < cookies.length; i++) {
            var cookie = jQuery.trim(cookies[i]);
            // Does this cookie string begin with the name we want?
            if (cookie.substring(0, name.length + 1) === (name + '=')) {
                cookieValue = decodeURIComponent(cookie.substring(name.length + 1));
                break;
            }
        }
    }
    return cookieValue;
}

// Funcion que generara una ficha tecnica de un vehiculo
async function generarFichaTecnica(
    id,
    sku
) {
    showLoadingAlert("Generando ficha tecnica...")
    const form = new FormData();
    form.append("id", id)
    const result = await fetch(
        `${FLOTILLAS_PREFIX}/generar-ficha-tecnica-vehiculo`,
        {
            method: "POST",
            headers: {
                "X-CSRFToken": getCookie("csrftoken")
            },
            body: form
        }
    )

    const blob = await result.blob()
    objUrl = URL.createObjectURL(blob)
    const a = document.createElement('a')
    a.style.setProperty('display', 'none')
    document.body.appendChild(a)
    a.href = objUrl
    a.download = `Ficha tecnica - ${sku}.pdf`
    a.click()
    window.URL.revokeObjectURL(objUrl)
    a.remove()
    Swal.close()
}