// Muestra una alerta de carga
function showLoadingAlert(
    title
) {
    Swal.fire({
        title: "",
        allowEscapeKey: false,
        allowOutsideClick: false,
        showConfirmButton: false,
        html: `
        <div style="vertical-align: middle" class="spinner-border text-primary" role="status">
        <span class="sr-only">Loading...</span>
        </div>
        <br>
        <br>
        <strong>${title}</strong>
        `
    });
}

function getCookie(name) {
    var cookieValue = null;
    if (document.cookie && document.cookie !== '') {
        var cookies = document.cookie.split(';');
        for (var i = 0; i < cookies.length; i++) {
            var cookie = jQuery.trim(cookies[i]);
            // Does this cookie string begin with the name we want?
            if (cookie.substring(0, name.length + 1) === (name + '=')) {
                cookieValue = decodeURIComponent(cookie.substring(name.length + 1));
                break;
            }
        }
    }
    return cookieValue;
}

// Funcion que generara un gafete de un colaborador con sus datos
async function generarGafete(
    id,
    curp
) {
    // getCookie("csrftoken")
    var csrftoken = $("[name=csrfmiddlewaretoken]").val();
    showLoadingAlert("Generando gafete...")
    const form = new FormData();
    form.append("id", id)
    const result = await fetch(
        `${COLABORADORES_PREFIX}/generar-gafete`,
        {
            method: "POST",
            body: form
        }
    )

    const blob = await result.blob()
    objUrl = URL.createObjectURL(blob)
    const a = document.createElement('a')
    a.style.setProperty('display', 'none')
    document.body.appendChild(a)
    a.href = objUrl
    a.download = `Gafete colaborador - ${curp}.pdf`
    a.click()
    window.URL.revokeObjectURL(objUrl)
    a.remove()
    Swal.close()
}

// Funcion que generara una ficha tecnica de un colaborador
async function generarFichaTecnica(
    id,
    curp
) {
    var csrftoken = $("[name=csrfmiddlewaretoken]").val();

    //alert(csrftoken)

    showLoadingAlert("Generando ficha tecnica...")
    const form = new FormData();
    form.append("id", id)
    const result = await fetch(
        `${COLABORADORES_PREFIX}/generar-ficha-tecnica`,
        {
            method: "POST",
            body: form
        }
    )

    const blob = await result.blob()
    objUrl = URL.createObjectURL(blob)
    const a = document.createElement('a')
    a.style.setProperty('display', 'none')
    document.body.appendChild(a)
    a.href = objUrl
    a.download = `Ficha tecnica - ${curp}.pdf`
    a.click()
    window.URL.revokeObjectURL(objUrl)
    a.remove()
    Swal.close()
}