// editar-puesto-col.js

$(document).ready(function () {
    // ----- Multiselect OFICINAS AL REGISTRAR PUESTO -------
    let oficinaSelectBtn = document.getElementById("oficina-select-btn")
    //const selectBtn = document.querySelector(".select-btn");
    //const oficinaItems = document.querySelectorAll(".item");
    let oficinaItems = document.querySelectorAll(".oficina-item")

    // Item default de el multiselect de oficinas
    const DEFAULT_OFICINAS_ITEM = "Todas las oficinas"

    oficinaSelectBtn.addEventListener("click", () => {
        //alert("click")
        oficinaSelectBtn.classList.toggle("open")
    })

    oficinaItems.forEach(item => {
        item.addEventListener("click", () => {
            item.classList.toggle("checked")

            //let checked = document.querySelectorAll(".checked"),
            //let checked = document.querySelectorAll('li[class="checked"][class="oficina-item"]')
            let checked = document.querySelectorAll(".checked.oficina-item")
            btnText = document.querySelector(".oficina-btn-text")


            if (checked && checked.length > 0) {
                btnText.innerText = `${checked.length} seleccionadas`
            } else {
                btnText.innerText = `Selecciona oficinas`
            }

            // Obtiene el texto de el primer elemento de la lista
            let itemText = item.getElementsByClassName("item-text")[0].textContent

            // Si selecciona el item (Todas las oficinas) marcara todas las opciones
            if (itemText == DEFAULT_OFICINAS_ITEM && item.classList.contains("checked") && checked.length >= 1) {
                oficinaItems.forEach(item => {
                    /*
                    let itemText = item.getElementsByClassName("item-text")[0].textContent
                    if (itemText != DEFAULT_OFICINAS_ITEM) {
                        item.classList.remove("checked")
                        btnText.innerText = DEFAULT_OFICINAS_ITEM
                    }
                        */
                    item.classList.add("checked")
                    btnText.innerText = DEFAULT_OFICINAS_ITEM
                })
            }

            // Si el usuario desmarca la opcion 'Todas las oficinas' desmarcara todas las opciones
            if (itemText == DEFAULT_OFICINAS_ITEM && !item.classList.contains("checked")) {
                oficinaItems.forEach(item => {
                    let itemText = item.getElementsByClassName("item-text")[0].textContent
                    if (itemText != DEFAULT_OFICINAS_ITEM) {
                        item.classList.remove("checked")
                        btnText.innerText = DEFAULT_OFICINAS_ITEM
                    }
                })
                // Establece texto en boton
                btnText.innerText = `Selecciona oficinas`
            }

            // Si el usuario desmarca alguna otra opcion que no sea 'Todas las oficinas' desmarcara la opcion de 'Todas las oficinas'
            // (Si esta marcada)
            if (itemText != DEFAULT_OFICINAS_ITEM && !item.classList.contains("checked")) {
                let defaultOficinaItem = oficinaItems[0] // 'Todas las oficinas'
                defaultOficinaItem.classList.remove("checked")

                // Despues de remover la opcion de 'Todas las oficinas',
                // Muestra el numero de opciones seleccionadas (Solo si hay almenos una)
                if (checked && checked.length > 0) {
                    checked = document.querySelectorAll(".checked.oficina-item")
                    btnText.innerText = `${checked.length} seleccionadas`
                }
            }

            // Si selecciona la primera opción(Todas las oficinas) y solo hay una opcion
            // seleccionada, mostrara otro texto de el boton
            if (checked && checked.length == 1 && itemText == DEFAULT_OFICINAS_ITEM) {
                btnText.innerText = DEFAULT_OFICINAS_ITEM
            }
        })
    })

    // Formulario de registro del puesto
    let editarPuestoForm = document.getElementById("editar-puesto-form")

    // Aqui agregara un evento de cuando se realize una busqueda(Suba el formulario)
    //$("#search-form").submit(function (evt) {
    editarPuestoForm.addEventListener("submit", function (evt) {
        showLoadingAlert('Modificando puesto...')

        // Cuando el formulario se suba, verificara que haya seleccionado por lo menos una oficina, de no ser asi
        // mostrara una alerta
        let itemsContainer = document.getElementById("oficina-select-list-items")
        let itemsCount = itemsContainer.querySelectorAll(".item.checked").length
        console.log("count" + itemsCount)
        if (itemsCount <= 0) {
            evt.preventDefault()
            Swal.close()
            showFailAlert("Aviso", "Debe seleccionar por lo menos una oficina.")
            return;
        }

        // Aqui obtiene las opciones seleccionadas del filtro de 'Oficinas'
        let oficinaListItems = document.getElementById("oficina-select-list-items")
        oficinaListItems = oficinaListItems.querySelectorAll("li")
        oficinaListItems.forEach(item => {
            // Si el item esta seleccionado
            if (item.classList.contains("checked")) {
                // Obtiene el texto de el item
                let textContent = item.getElementsByClassName("item-text")[0].textContent
                // Crea un input hidden para enviarlo para la busqueda
                let inputHidden = document.createElement("input")
                inputHidden.type = "hidden"
                inputHidden.value = textContent
                inputHidden.name = "oficinas-items[]"
                // Agrega el input al formulario de busqueda
                editarPuestoForm.appendChild(inputHidden)

            }
        })
    })
})

// Funcion que recupera las oficinas seleccionadas al querer agregar un puesto
function recuperarOficinas(oficinasResponse) {
    //console.log(searchResponse)
    // Obtiene la respuesta de recuperacion de filtros y lo convierte a un objeto JavaScript
    let oficinasResponseO = JSON.parse(oficinasResponse)

    // Lista de opciones de oficinas seleccionadas
    let oficinasListQuery = oficinasResponseO["oficinas_list"]

    $(document).ready(function () {
        // ---- Recupera los filtros seleccionados de oficina ----

        try {
            // Obtiene todos los items <li> de el filtro de oficina
            let oficinaItems = document.querySelectorAll(".oficina-item")
            // Boton de multiselect
            let btnText = document.querySelector(".oficina-btn-text")
            // Itera sobre cada item visual y verifica si conincide con alguna opcion seleccionada de los filtros de busqueda
            // de ser asi, marcara el item visual como seleccionado (Simulando un click)
            oficinaItems.forEach(item => {
                let text = item.getElementsByClassName("item-text")[0].textContent
                //alert(text)
                for (var x = 0; x < oficinasListQuery.length; x++) {
                    if (text == oficinasListQuery[x]) {
                        // Marca la opcion como seleccionada
                        //item.click()
                        // Si se selecciono el item 'Todas las oficinas' marcara visualmente el item
                        // y cambiara el texto del boton de multiselect
                        if (oficinasListQuery.includes("Todas las oficinas")) {
                            item.classList.add("checked")
                            btnText.innerText = "Todas las oficinas"
                        } else {
                            item.click()
                        }
                    }
                }
            })
        }
        catch (excepcion) {
            console.error(excepcion)
        }

    })
}