// admin-usuarios.js

USUARIOS_PREFIX = `${BASE_URL}usuarios`

// Funcion que mostrara una lista de las oficinas de un usuario en especifico
function showOfficeGestor(id, rango) {
    var csrftoken = $("[name=csrfmiddlewaretoken]").val();

    $.ajax({
        type: "POST",
        url: `${USUARIOS_PREFIX}/obtener-oficinas-gestor`,
        headers: {
            "X-CSRFToken": csrftoken
        },
        data: {
            id: id
        },
        success: function (result) {
            var json = JSON.stringify(result)
            json = JSON.parse(json)

            var html = `
            <h2>Oficinas administradas</h2>
                <br>
                <table class="table table-striped table-hover">
                                        <tr>
                                            <th>Nombre de oficina</th>
                                        <tr>
            `

            // Key -> Contendra el nombre de la oficina
            if (rango == RH_RANGO || rango == CABINA_RANGO || rango == CONTRALOR_RANGO) { // Si es gestor o cabina
                $.each(json, function (key, value) {
                    html += `
                        <tr>
                            <td>${key}</td>
                        </tr>
                    `
                })
            } else { // Si es administrador
                html += `
                    <tr>
                        <td>Todas</td>
                    </tr>
                `
            }

            html += `
                </table>
            `
            Swal.fire({
                html: html
            });
        },
        error: function (a, b, c) {
            alert("Error: " + a + " " + b + "" + c)
        }
    })
}