function subirTemas(id) {
    var csrftoken = $("[name=csrfmiddlewaretoken]").val();

    Swal.fire({
        title: 'Selecciona un archivo',
        showCancelButton: true,
        confirmButtonText: 'Subir',
        inputAttributes: {
            "accept": "application/pdf",
            "aria-label": "Subir temas"
        },
        input: 'file',
        onBeforeOpen: () => {
            $(".swal2-file").change(function () {
                var reader = new FileReader();
                reader.readAsDataURL(this.files[0]);
            });
        }
    }).then((file) => {
        if (file.value) {
            var formData = new FormData();
            var file = $('.swal2-file')[0].files[0];
            formData.append("temasFile", file);
            formData.append("cursoId", id)
            $.ajax({
                headers: { 'X-CSRFToken': csrftoken },
                method: 'post',
                url: `${BASE_URL}colaboradores/subir-temas-curso`,
                data: formData,
                processData: false,
                contentType: false,
                success: function (resp) {
                    Swal.fire(
                        {
                            title: "¡Exito!",
                            text: "Se subieron los temas al curso exitosamente.",
                            icon: 'success',
                            allowOutsideClick: false
                        }
                    ).then((result) => {
                        if (result.isConfirmed) {
                            location.reload()
                        }
                    })
                },
                error: function (a, b, c) {
                    alert(a + b + c)
                }
            })
        }
    })
}

